/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.services.elasticloadbalancingv2.model.Cipher;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class CipherStaxUnmarshaller
implements Unmarshaller<Cipher, StaxUnmarshallerContext> {
    private static CipherStaxUnmarshaller instance;

    @Override
    public Cipher unmarshall(StaxUnmarshallerContext context) throws Exception {
        Cipher cipher = new Cipher();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return cipher;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    cipher.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Priority", targetDepth)) continue;
                cipher.setPriority(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return cipher;
    }

    public static CipherStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CipherStaxUnmarshaller();
        }
        return instance;
    }
}

