/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListHostedZonesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListHostedZonesRequestMarshaller
implements Marshaller<Request<ListHostedZonesRequest>, ListHostedZonesRequest> {
    @Override
    public Request<ListHostedZonesRequest> marshall(ListHostedZonesRequest listHostedZonesRequest) {
        if (listHostedZonesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListHostedZonesRequest> request = new DefaultRequest<ListHostedZonesRequest>(listHostedZonesRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/hostedzone";
        request.setResourcePath(uriResourcePath);
        if (listHostedZonesRequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString(listHostedZonesRequest.getMarker()));
        }
        if (listHostedZonesRequest.getMaxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString(listHostedZonesRequest.getMaxItems()));
        }
        if (listHostedZonesRequest.getDelegationSetId() != null) {
            request.addParameter("delegationsetid", StringUtils.fromString(listHostedZonesRequest.getDelegationSetId()));
        }
        return request;
    }
}

