/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.DescribeFleetPortSettingsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeFleetPortSettingsRequestMarshaller
implements Marshaller<Request<DescribeFleetPortSettingsRequest>, DescribeFleetPortSettingsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeFleetPortSettingsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeFleetPortSettingsRequest> marshall(DescribeFleetPortSettingsRequest describeFleetPortSettingsRequest) {
        if (describeFleetPortSettingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeFleetPortSettingsRequest> request = new DefaultRequest<DescribeFleetPortSettingsRequest>(describeFleetPortSettingsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.DescribeFleetPortSettings");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeFleetPortSettingsRequest.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(describeFleetPortSettingsRequest.getFleetId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

