/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CancelSpotFleetRequestsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CancelSpotFleetRequestsRequestMarshaller
implements Marshaller<Request<CancelSpotFleetRequestsRequest>, CancelSpotFleetRequestsRequest> {
    @Override
    public Request<CancelSpotFleetRequestsRequest> marshall(CancelSpotFleetRequestsRequest cancelSpotFleetRequestsRequest) {
        if (cancelSpotFleetRequestsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CancelSpotFleetRequestsRequest> request = new DefaultRequest<CancelSpotFleetRequestsRequest>(cancelSpotFleetRequestsRequest, "AmazonEC2");
        request.addParameter("Action", "CancelSpotFleetRequests");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList spotFleetRequestIdsList = (SdkInternalList)cancelSpotFleetRequestsRequest.getSpotFleetRequestIds();
        if (!spotFleetRequestIdsList.isEmpty() || !spotFleetRequestIdsList.isAutoConstruct()) {
            int spotFleetRequestIdsListIndex = 1;
            for (String spotFleetRequestIdsListValue : spotFleetRequestIdsList) {
                if (spotFleetRequestIdsListValue != null) {
                    request.addParameter("SpotFleetRequestId." + spotFleetRequestIdsListIndex, StringUtils.fromString(spotFleetRequestIdsListValue));
                }
                ++spotFleetRequestIdsListIndex;
            }
        }
        if (cancelSpotFleetRequestsRequest.getTerminateInstances() != null) {
            request.addParameter("TerminateInstances", StringUtils.fromBoolean(cancelSpotFleetRequestsRequest.getTerminateInstances()));
        }
        return request;
    }
}

