/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutNotificationConfigurationRequestMarshaller
implements Marshaller<Request<PutNotificationConfigurationRequest>, PutNotificationConfigurationRequest> {
    @Override
    public Request<PutNotificationConfigurationRequest> marshall(PutNotificationConfigurationRequest putNotificationConfigurationRequest) {
        SdkInternalList notificationTypesList;
        if (putNotificationConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutNotificationConfigurationRequest> request = new DefaultRequest<PutNotificationConfigurationRequest>(putNotificationConfigurationRequest, "AmazonAutoScaling");
        request.addParameter("Action", "PutNotificationConfiguration");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putNotificationConfigurationRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(putNotificationConfigurationRequest.getAutoScalingGroupName()));
        }
        if (putNotificationConfigurationRequest.getTopicARN() != null) {
            request.addParameter("TopicARN", StringUtils.fromString(putNotificationConfigurationRequest.getTopicARN()));
        }
        if (!(notificationTypesList = (SdkInternalList)putNotificationConfigurationRequest.getNotificationTypes()).isEmpty() || !notificationTypesList.isAutoConstruct()) {
            int notificationTypesListIndex = 1;
            for (String notificationTypesListValue : notificationTypesList) {
                if (notificationTypesListValue != null) {
                    request.addParameter("NotificationTypes.member." + notificationTypesListIndex, StringUtils.fromString(notificationTypesListValue));
                }
                ++notificationTypesListIndex;
            }
        }
        return request;
    }
}

