/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.services.stepfunctions.builder.internal.Buildable;
import com.amazonaws.services.stepfunctions.builder.states.NextStateTransition;
import com.amazonaws.services.stepfunctions.builder.states.Transition;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Catcher {
    @JsonProperty(value="ErrorEquals")
    private final List<String> errorEquals;
    @JsonProperty(value="ResultPath")
    private final String resultPath;
    @JsonUnwrapped
    private final Transition transition;

    private Catcher(Builder builder) {
        this.errorEquals = new ArrayList<String>(builder.errorEquals);
        this.resultPath = builder.resultPath;
        this.transition = (Transition)builder.transition.build();
    }

    public List<String> getErrorEquals() {
        return this.errorEquals;
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements Buildable<Catcher> {
        @JsonProperty(value="ErrorEquals")
        private List<String> errorEquals = new ArrayList<String>();
        @JsonProperty(value="ResultPath")
        private String resultPath;
        private Transition.Builder transition = Transition.NULL_BUILDER;

        private Builder() {
        }

        public Builder errorEquals(String ... errorEquals) {
            Collections.addAll(this.errorEquals, errorEquals);
            return this;
        }

        public Builder catchAll() {
            this.errorEquals.clear();
            this.errorEquals("States.ALL");
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        @JsonProperty(value="Next")
        private Builder nextStateName(String nextStateName) {
            return this.transition(NextStateTransition.builder().nextStateName(nextStateName));
        }

        public Builder transition(NextStateTransition.Builder transition) {
            this.transition = transition;
            return this;
        }

        @Override
        public Catcher build() {
            return new Catcher(this);
        }
    }
}

