/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RestartAppServerRequestMarshaller
implements Marshaller<Request<RestartAppServerRequest>, RestartAppServerRequest> {
    @Override
    public Request<RestartAppServerRequest> marshall(RestartAppServerRequest restartAppServerRequest) {
        if (restartAppServerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RestartAppServerRequest> request = new DefaultRequest<RestartAppServerRequest>(restartAppServerRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "RestartAppServer");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (restartAppServerRequest.getEnvironmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString(restartAppServerRequest.getEnvironmentId()));
        }
        if (restartAppServerRequest.getEnvironmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString(restartAppServerRequest.getEnvironmentName()));
        }
        return request;
    }
}

