/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.services.stepfunctions.builder.states.State;
import com.amazonaws.services.stepfunctions.builder.states.StateVisitor;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SucceedState
implements State {
    @JsonProperty(value="Comment")
    private final String comment;
    @JsonProperty(value="InputPath")
    private final String inputPath;
    @JsonProperty(value="OutputPath")
    private final String outputPath;

    private SucceedState(Builder builder) {
        this.comment = builder.comment;
        this.inputPath = builder.inputPath;
        this.outputPath = builder.outputPath;
    }

    @Override
    public String getType() {
        return "Succeed";
    }

    public String getComment() {
        return this.comment;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    @Override
    public boolean isTerminalState() {
        return true;
    }

    @Override
    public <T> T accept(StateVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements State.Builder {
        @JsonProperty(value="Comment")
        private String comment;
        @JsonProperty(value="InputPath")
        private String inputPath;
        @JsonProperty(value="OutputPath")
        private String outputPath;

        private Builder() {
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        @Override
        public SucceedState build() {
            return new SucceedState(this);
        }
    }
}

