/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workspaces.model.DefaultWorkspaceCreationProperties;
import com.amazonaws.services.workspaces.model.WorkspaceDirectoryState;
import com.amazonaws.services.workspaces.model.WorkspaceDirectoryType;
import com.amazonaws.services.workspaces.model.transform.WorkspaceDirectoryMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class WorkspaceDirectory
implements Serializable,
Cloneable,
StructuredPojo {
    private String directoryId;
    private String alias;
    private String directoryName;
    private String registrationCode;
    private SdkInternalList<String> subnetIds;
    private SdkInternalList<String> dnsIpAddresses;
    private String customerUserName;
    private String iamRoleId;
    private String directoryType;
    private String workspaceSecurityGroupId;
    private String state;
    private DefaultWorkspaceCreationProperties workspaceCreationProperties;

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public WorkspaceDirectory withDirectoryId(String directoryId) {
        this.setDirectoryId(directoryId);
        return this;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public WorkspaceDirectory withAlias(String alias) {
        this.setAlias(alias);
        return this;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public WorkspaceDirectory withDirectoryName(String directoryName) {
        this.setDirectoryName(directoryName);
        return this;
    }

    public void setRegistrationCode(String registrationCode) {
        this.registrationCode = registrationCode;
    }

    public String getRegistrationCode() {
        return this.registrationCode;
    }

    public WorkspaceDirectory withRegistrationCode(String registrationCode) {
        this.setRegistrationCode(registrationCode);
        return this;
    }

    public List<String> getSubnetIds() {
        if (this.subnetIds == null) {
            this.subnetIds = new SdkInternalList();
        }
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        this.subnetIds = new SdkInternalList<String>(subnetIds);
    }

    public WorkspaceDirectory withSubnetIds(String ... subnetIds) {
        if (this.subnetIds == null) {
            this.setSubnetIds(new SdkInternalList<String>(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add(ele);
        }
        return this;
    }

    public WorkspaceDirectory withSubnetIds(Collection<String> subnetIds) {
        this.setSubnetIds(subnetIds);
        return this;
    }

    public List<String> getDnsIpAddresses() {
        if (this.dnsIpAddresses == null) {
            this.dnsIpAddresses = new SdkInternalList();
        }
        return this.dnsIpAddresses;
    }

    public void setDnsIpAddresses(Collection<String> dnsIpAddresses) {
        if (dnsIpAddresses == null) {
            this.dnsIpAddresses = null;
            return;
        }
        this.dnsIpAddresses = new SdkInternalList<String>(dnsIpAddresses);
    }

    public WorkspaceDirectory withDnsIpAddresses(String ... dnsIpAddresses) {
        if (this.dnsIpAddresses == null) {
            this.setDnsIpAddresses(new SdkInternalList<String>(dnsIpAddresses.length));
        }
        for (String ele : dnsIpAddresses) {
            this.dnsIpAddresses.add(ele);
        }
        return this;
    }

    public WorkspaceDirectory withDnsIpAddresses(Collection<String> dnsIpAddresses) {
        this.setDnsIpAddresses(dnsIpAddresses);
        return this;
    }

    public void setCustomerUserName(String customerUserName) {
        this.customerUserName = customerUserName;
    }

    public String getCustomerUserName() {
        return this.customerUserName;
    }

    public WorkspaceDirectory withCustomerUserName(String customerUserName) {
        this.setCustomerUserName(customerUserName);
        return this;
    }

    public void setIamRoleId(String iamRoleId) {
        this.iamRoleId = iamRoleId;
    }

    public String getIamRoleId() {
        return this.iamRoleId;
    }

    public WorkspaceDirectory withIamRoleId(String iamRoleId) {
        this.setIamRoleId(iamRoleId);
        return this;
    }

    public void setDirectoryType(String directoryType) {
        this.directoryType = directoryType;
    }

    public String getDirectoryType() {
        return this.directoryType;
    }

    public WorkspaceDirectory withDirectoryType(String directoryType) {
        this.setDirectoryType(directoryType);
        return this;
    }

    @JsonIgnore
    public void setDirectoryType(WorkspaceDirectoryType directoryType) {
        this.directoryType = directoryType.toString();
    }

    public WorkspaceDirectory withDirectoryType(WorkspaceDirectoryType directoryType) {
        this.setDirectoryType(directoryType);
        return this;
    }

    public void setWorkspaceSecurityGroupId(String workspaceSecurityGroupId) {
        this.workspaceSecurityGroupId = workspaceSecurityGroupId;
    }

    public String getWorkspaceSecurityGroupId() {
        return this.workspaceSecurityGroupId;
    }

    public WorkspaceDirectory withWorkspaceSecurityGroupId(String workspaceSecurityGroupId) {
        this.setWorkspaceSecurityGroupId(workspaceSecurityGroupId);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public WorkspaceDirectory withState(String state) {
        this.setState(state);
        return this;
    }

    @JsonIgnore
    public void setState(WorkspaceDirectoryState state) {
        this.state = state.toString();
    }

    public WorkspaceDirectory withState(WorkspaceDirectoryState state) {
        this.setState(state);
        return this;
    }

    public void setWorkspaceCreationProperties(DefaultWorkspaceCreationProperties workspaceCreationProperties) {
        this.workspaceCreationProperties = workspaceCreationProperties;
    }

    public DefaultWorkspaceCreationProperties getWorkspaceCreationProperties() {
        return this.workspaceCreationProperties;
    }

    public WorkspaceDirectory withWorkspaceCreationProperties(DefaultWorkspaceCreationProperties workspaceCreationProperties) {
        this.setWorkspaceCreationProperties(workspaceCreationProperties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryId() != null) {
            sb.append("DirectoryId: ").append(this.getDirectoryId()).append(",");
        }
        if (this.getAlias() != null) {
            sb.append("Alias: ").append(this.getAlias()).append(",");
        }
        if (this.getDirectoryName() != null) {
            sb.append("DirectoryName: ").append(this.getDirectoryName()).append(",");
        }
        if (this.getRegistrationCode() != null) {
            sb.append("RegistrationCode: ").append(this.getRegistrationCode()).append(",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: ").append(this.getSubnetIds()).append(",");
        }
        if (this.getDnsIpAddresses() != null) {
            sb.append("DnsIpAddresses: ").append(this.getDnsIpAddresses()).append(",");
        }
        if (this.getCustomerUserName() != null) {
            sb.append("CustomerUserName: ").append(this.getCustomerUserName()).append(",");
        }
        if (this.getIamRoleId() != null) {
            sb.append("IamRoleId: ").append(this.getIamRoleId()).append(",");
        }
        if (this.getDirectoryType() != null) {
            sb.append("DirectoryType: ").append(this.getDirectoryType()).append(",");
        }
        if (this.getWorkspaceSecurityGroupId() != null) {
            sb.append("WorkspaceSecurityGroupId: ").append(this.getWorkspaceSecurityGroupId()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getWorkspaceCreationProperties() != null) {
            sb.append("WorkspaceCreationProperties: ").append(this.getWorkspaceCreationProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceDirectory)) {
            return false;
        }
        WorkspaceDirectory other = (WorkspaceDirectory)obj;
        if (other.getDirectoryId() == null ^ this.getDirectoryId() == null) {
            return false;
        }
        if (other.getDirectoryId() != null && !other.getDirectoryId().equals(this.getDirectoryId())) {
            return false;
        }
        if (other.getAlias() == null ^ this.getAlias() == null) {
            return false;
        }
        if (other.getAlias() != null && !other.getAlias().equals(this.getAlias())) {
            return false;
        }
        if (other.getDirectoryName() == null ^ this.getDirectoryName() == null) {
            return false;
        }
        if (other.getDirectoryName() != null && !other.getDirectoryName().equals(this.getDirectoryName())) {
            return false;
        }
        if (other.getRegistrationCode() == null ^ this.getRegistrationCode() == null) {
            return false;
        }
        if (other.getRegistrationCode() != null && !other.getRegistrationCode().equals(this.getRegistrationCode())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getDnsIpAddresses() == null ^ this.getDnsIpAddresses() == null) {
            return false;
        }
        if (other.getDnsIpAddresses() != null && !other.getDnsIpAddresses().equals(this.getDnsIpAddresses())) {
            return false;
        }
        if (other.getCustomerUserName() == null ^ this.getCustomerUserName() == null) {
            return false;
        }
        if (other.getCustomerUserName() != null && !other.getCustomerUserName().equals(this.getCustomerUserName())) {
            return false;
        }
        if (other.getIamRoleId() == null ^ this.getIamRoleId() == null) {
            return false;
        }
        if (other.getIamRoleId() != null && !other.getIamRoleId().equals(this.getIamRoleId())) {
            return false;
        }
        if (other.getDirectoryType() == null ^ this.getDirectoryType() == null) {
            return false;
        }
        if (other.getDirectoryType() != null && !other.getDirectoryType().equals(this.getDirectoryType())) {
            return false;
        }
        if (other.getWorkspaceSecurityGroupId() == null ^ this.getWorkspaceSecurityGroupId() == null) {
            return false;
        }
        if (other.getWorkspaceSecurityGroupId() != null && !other.getWorkspaceSecurityGroupId().equals(this.getWorkspaceSecurityGroupId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getWorkspaceCreationProperties() == null ^ this.getWorkspaceCreationProperties() == null) {
            return false;
        }
        return other.getWorkspaceCreationProperties() == null || other.getWorkspaceCreationProperties().equals(this.getWorkspaceCreationProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryId() == null ? 0 : this.getDirectoryId().hashCode());
        hashCode = 31 * hashCode + (this.getAlias() == null ? 0 : this.getAlias().hashCode());
        hashCode = 31 * hashCode + (this.getDirectoryName() == null ? 0 : this.getDirectoryName().hashCode());
        hashCode = 31 * hashCode + (this.getRegistrationCode() == null ? 0 : this.getRegistrationCode().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getDnsIpAddresses() == null ? 0 : this.getDnsIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerUserName() == null ? 0 : this.getCustomerUserName().hashCode());
        hashCode = 31 * hashCode + (this.getIamRoleId() == null ? 0 : this.getIamRoleId().hashCode());
        hashCode = 31 * hashCode + (this.getDirectoryType() == null ? 0 : this.getDirectoryType().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceSecurityGroupId() == null ? 0 : this.getWorkspaceSecurityGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceCreationProperties() == null ? 0 : this.getWorkspaceCreationProperties().hashCode());
        return hashCode;
    }

    public WorkspaceDirectory clone() {
        try {
            return (WorkspaceDirectory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkspaceDirectoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

