/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.rekognition.AmazonRekognitionAsync;
import com.amazonaws.services.rekognition.AmazonRekognitionAsyncClientBuilder;
import com.amazonaws.services.rekognition.AmazonRekognitionClient;
import com.amazonaws.services.rekognition.model.CompareFacesRequest;
import com.amazonaws.services.rekognition.model.CompareFacesResult;
import com.amazonaws.services.rekognition.model.CreateCollectionRequest;
import com.amazonaws.services.rekognition.model.CreateCollectionResult;
import com.amazonaws.services.rekognition.model.DeleteCollectionRequest;
import com.amazonaws.services.rekognition.model.DeleteCollectionResult;
import com.amazonaws.services.rekognition.model.DeleteFacesRequest;
import com.amazonaws.services.rekognition.model.DeleteFacesResult;
import com.amazonaws.services.rekognition.model.DetectFacesRequest;
import com.amazonaws.services.rekognition.model.DetectFacesResult;
import com.amazonaws.services.rekognition.model.DetectLabelsRequest;
import com.amazonaws.services.rekognition.model.DetectLabelsResult;
import com.amazonaws.services.rekognition.model.IndexFacesRequest;
import com.amazonaws.services.rekognition.model.IndexFacesResult;
import com.amazonaws.services.rekognition.model.ListCollectionsRequest;
import com.amazonaws.services.rekognition.model.ListCollectionsResult;
import com.amazonaws.services.rekognition.model.ListFacesRequest;
import com.amazonaws.services.rekognition.model.ListFacesResult;
import com.amazonaws.services.rekognition.model.SearchFacesByImageRequest;
import com.amazonaws.services.rekognition.model.SearchFacesByImageResult;
import com.amazonaws.services.rekognition.model.SearchFacesRequest;
import com.amazonaws.services.rekognition.model.SearchFacesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonRekognitionAsyncClient
extends AmazonRekognitionClient
implements AmazonRekognitionAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonRekognitionAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonRekognitionAsyncClientBuilder asyncBuilder() {
        return AmazonRekognitionAsyncClientBuilder.standard();
    }

    AmazonRekognitionAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CompareFacesResult> compareFacesAsync(CompareFacesRequest request) {
        return this.compareFacesAsync(request, null);
    }

    @Override
    public Future<CompareFacesResult> compareFacesAsync(final CompareFacesRequest request, final AsyncHandler<CompareFacesRequest, CompareFacesResult> asyncHandler) {
        return this.executorService.submit(new Callable<CompareFacesResult>(){

            @Override
            public CompareFacesResult call() throws Exception {
                CompareFacesResult result;
                try {
                    result = AmazonRekognitionAsyncClient.this.compareFaces(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCollectionResult> createCollectionAsync(CreateCollectionRequest request) {
        return this.createCollectionAsync(request, null);
    }

    @Override
    public Future<CreateCollectionResult> createCollectionAsync(final CreateCollectionRequest request, final AsyncHandler<CreateCollectionRequest, CreateCollectionResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateCollectionResult>(){

            @Override
            public CreateCollectionResult call() throws Exception {
                CreateCollectionResult result;
                try {
                    result = AmazonRekognitionAsyncClient.this.createCollection(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCollectionResult> deleteCollectionAsync(DeleteCollectionRequest request) {
        return this.deleteCollectionAsync(request, null);
    }

    @Override
    public Future<DeleteCollectionResult> deleteCollectionAsync(final DeleteCollectionRequest request, final AsyncHandler<DeleteCollectionRequest, DeleteCollectionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteCollectionResult>(){

            @Override
            public DeleteCollectionResult call() throws Exception {
                DeleteCollectionResult result;
                try {
                    result = AmazonRekognitionAsyncClient.this.deleteCollection(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFacesResult> deleteFacesAsync(DeleteFacesRequest request) {
        return this.deleteFacesAsync(request, null);
    }

    @Override
    public Future<DeleteFacesResult> deleteFacesAsync(final DeleteFacesRequest request, final AsyncHandler<DeleteFacesRequest, DeleteFacesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteFacesResult>(){

            @Override
            public DeleteFacesResult call() throws Exception {
                DeleteFacesResult result;
                try {
                    result = AmazonRekognitionAsyncClient.this.deleteFaces(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectFacesResult> detectFacesAsync(DetectFacesRequest request) {
        return this.detectFacesAsync(request, null);
    }

    @Override
    public Future<DetectFacesResult> detectFacesAsync(final DetectFacesRequest request, final AsyncHandler<DetectFacesRequest, DetectFacesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DetectFacesResult>(){

            @Override
            public DetectFacesResult call() throws Exception {
                DetectFacesResult result;
                try {
                    result = AmazonRekognitionAsyncClient.this.detectFaces(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectLabelsResult> detectLabelsAsync(DetectLabelsRequest request) {
        return this.detectLabelsAsync(request, null);
    }

    @Override
    public Future<DetectLabelsResult> detectLabelsAsync(final DetectLabelsRequest request, final AsyncHandler<DetectLabelsRequest, DetectLabelsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DetectLabelsResult>(){

            @Override
            public DetectLabelsResult call() throws Exception {
                DetectLabelsResult result;
                try {
                    result = AmazonRekognitionAsyncClient.this.detectLabels(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<IndexFacesResult> indexFacesAsync(IndexFacesRequest request) {
        return this.indexFacesAsync(request, null);
    }

    @Override
    public Future<IndexFacesResult> indexFacesAsync(final IndexFacesRequest request, final AsyncHandler<IndexFacesRequest, IndexFacesResult> asyncHandler) {
        return this.executorService.submit(new Callable<IndexFacesResult>(){

            @Override
            public IndexFacesResult call() throws Exception {
                IndexFacesResult result;
                try {
                    result = AmazonRekognitionAsyncClient.this.indexFaces(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCollectionsResult> listCollectionsAsync(ListCollectionsRequest request) {
        return this.listCollectionsAsync(request, null);
    }

    @Override
    public Future<ListCollectionsResult> listCollectionsAsync(final ListCollectionsRequest request, final AsyncHandler<ListCollectionsRequest, ListCollectionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListCollectionsResult>(){

            @Override
            public ListCollectionsResult call() throws Exception {
                ListCollectionsResult result;
                try {
                    result = AmazonRekognitionAsyncClient.this.listCollections(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFacesResult> listFacesAsync(ListFacesRequest request) {
        return this.listFacesAsync(request, null);
    }

    @Override
    public Future<ListFacesResult> listFacesAsync(final ListFacesRequest request, final AsyncHandler<ListFacesRequest, ListFacesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListFacesResult>(){

            @Override
            public ListFacesResult call() throws Exception {
                ListFacesResult result;
                try {
                    result = AmazonRekognitionAsyncClient.this.listFaces(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchFacesResult> searchFacesAsync(SearchFacesRequest request) {
        return this.searchFacesAsync(request, null);
    }

    @Override
    public Future<SearchFacesResult> searchFacesAsync(final SearchFacesRequest request, final AsyncHandler<SearchFacesRequest, SearchFacesResult> asyncHandler) {
        return this.executorService.submit(new Callable<SearchFacesResult>(){

            @Override
            public SearchFacesResult call() throws Exception {
                SearchFacesResult result;
                try {
                    result = AmazonRekognitionAsyncClient.this.searchFaces(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchFacesByImageResult> searchFacesByImageAsync(SearchFacesByImageRequest request) {
        return this.searchFacesByImageAsync(request, null);
    }

    @Override
    public Future<SearchFacesByImageResult> searchFacesByImageAsync(final SearchFacesByImageRequest request, final AsyncHandler<SearchFacesByImageRequest, SearchFacesByImageResult> asyncHandler) {
        return this.executorService.submit(new Callable<SearchFacesByImageResult>(){

            @Override
            public SearchFacesByImageResult call() throws Exception {
                SearchFacesByImageResult result;
                try {
                    result = AmazonRekognitionAsyncClient.this.searchFacesByImage(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

