/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.ModifyDBSnapshotAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyDBSnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifyDBSnapshotAttributeRequest>, ModifyDBSnapshotAttributeRequest> {
    @Override
    public Request<ModifyDBSnapshotAttributeRequest> marshall(ModifyDBSnapshotAttributeRequest modifyDBSnapshotAttributeRequest) {
        SdkInternalList valuesToRemoveList;
        SdkInternalList valuesToAddList;
        if (modifyDBSnapshotAttributeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyDBSnapshotAttributeRequest> request = new DefaultRequest<ModifyDBSnapshotAttributeRequest>(modifyDBSnapshotAttributeRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyDBSnapshotAttribute");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBSnapshotAttributeRequest.getDBSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringUtils.fromString(modifyDBSnapshotAttributeRequest.getDBSnapshotIdentifier()));
        }
        if (modifyDBSnapshotAttributeRequest.getAttributeName() != null) {
            request.addParameter("AttributeName", StringUtils.fromString(modifyDBSnapshotAttributeRequest.getAttributeName()));
        }
        if (!(valuesToAddList = (SdkInternalList)modifyDBSnapshotAttributeRequest.getValuesToAdd()).isEmpty() || !valuesToAddList.isAutoConstruct()) {
            int valuesToAddListIndex = 1;
            for (String valuesToAddListValue : valuesToAddList) {
                if (valuesToAddListValue != null) {
                    request.addParameter("ValuesToAdd.AttributeValue." + valuesToAddListIndex, StringUtils.fromString(valuesToAddListValue));
                }
                ++valuesToAddListIndex;
            }
        }
        if (!(valuesToRemoveList = (SdkInternalList)modifyDBSnapshotAttributeRequest.getValuesToRemove()).isEmpty() || !valuesToRemoveList.isAutoConstruct()) {
            int valuesToRemoveListIndex = 1;
            for (String valuesToRemoveListValue : valuesToRemoveList) {
                if (valuesToRemoveListValue != null) {
                    request.addParameter("ValuesToRemove.AttributeValue." + valuesToRemoveListIndex, StringUtils.fromString(valuesToRemoveListValue));
                }
                ++valuesToRemoveListIndex;
            }
        }
        return request;
    }
}

