/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacemetering.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.marketplacemetering.model.MeterUsageRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class MeterUsageRequestMarshaller
implements Marshaller<Request<MeterUsageRequest>, MeterUsageRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public MeterUsageRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<MeterUsageRequest> marshall(MeterUsageRequest meterUsageRequest) {
        if (meterUsageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<MeterUsageRequest> request = new DefaultRequest<MeterUsageRequest>(meterUsageRequest, "AWSMarketplaceMetering");
        request.addHeader("X-Amz-Target", "AWSMPMeteringService.MeterUsage");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (meterUsageRequest.getProductCode() != null) {
                jsonGenerator.writeFieldName("ProductCode").writeValue(meterUsageRequest.getProductCode());
            }
            if (meterUsageRequest.getTimestamp() != null) {
                jsonGenerator.writeFieldName("Timestamp").writeValue(meterUsageRequest.getTimestamp());
            }
            if (meterUsageRequest.getUsageDimension() != null) {
                jsonGenerator.writeFieldName("UsageDimension").writeValue(meterUsageRequest.getUsageDimension());
            }
            if (meterUsageRequest.getUsageQuantity() != null) {
                jsonGenerator.writeFieldName("UsageQuantity").writeValue(meterUsageRequest.getUsageQuantity());
            }
            if (meterUsageRequest.getDryRun() != null) {
                jsonGenerator.writeFieldName("DryRun").writeValue(meterUsageRequest.getDryRun());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

