/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kms.model.ListRetirableGrantsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListRetirableGrantsRequestMarshaller
implements Marshaller<Request<ListRetirableGrantsRequest>, ListRetirableGrantsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListRetirableGrantsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListRetirableGrantsRequest> marshall(ListRetirableGrantsRequest listRetirableGrantsRequest) {
        if (listRetirableGrantsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListRetirableGrantsRequest> request = new DefaultRequest<ListRetirableGrantsRequest>(listRetirableGrantsRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.ListRetirableGrants");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listRetirableGrantsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listRetirableGrantsRequest.getLimit());
            }
            if (listRetirableGrantsRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listRetirableGrantsRequest.getMarker());
            }
            if (listRetirableGrantsRequest.getRetiringPrincipal() != null) {
                jsonGenerator.writeFieldName("RetiringPrincipal").writeValue(listRetirableGrantsRequest.getRetiringPrincipal());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

