/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.CreateFleetRequest;
import com.amazonaws.services.gamelift.model.IpPermission;
import com.amazonaws.services.gamelift.model.transform.IpPermissionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateFleetRequestMarshaller
implements Marshaller<Request<CreateFleetRequest>, CreateFleetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateFleetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateFleetRequest> marshall(CreateFleetRequest createFleetRequest) {
        if (createFleetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateFleetRequest> request = new DefaultRequest<CreateFleetRequest>(createFleetRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.CreateFleet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<IpPermission> eC2InboundPermissionsList;
            List<String> logPathsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createFleetRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createFleetRequest.getName());
            }
            if (createFleetRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createFleetRequest.getDescription());
            }
            if (createFleetRequest.getBuildId() != null) {
                jsonGenerator.writeFieldName("BuildId").writeValue(createFleetRequest.getBuildId());
            }
            if (createFleetRequest.getServerLaunchPath() != null) {
                jsonGenerator.writeFieldName("ServerLaunchPath").writeValue(createFleetRequest.getServerLaunchPath());
            }
            if (createFleetRequest.getServerLaunchParameters() != null) {
                jsonGenerator.writeFieldName("ServerLaunchParameters").writeValue(createFleetRequest.getServerLaunchParameters());
            }
            if ((logPathsList = createFleetRequest.getLogPaths()) != null) {
                jsonGenerator.writeFieldName("LogPaths");
                jsonGenerator.writeStartArray();
                for (String logPathsListValue : logPathsList) {
                    if (logPathsListValue == null) continue;
                    jsonGenerator.writeValue(logPathsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createFleetRequest.getEC2InstanceType() != null) {
                jsonGenerator.writeFieldName("EC2InstanceType").writeValue(createFleetRequest.getEC2InstanceType());
            }
            if ((eC2InboundPermissionsList = createFleetRequest.getEC2InboundPermissions()) != null) {
                jsonGenerator.writeFieldName("EC2InboundPermissions");
                jsonGenerator.writeStartArray();
                for (IpPermission eC2InboundPermissionsListValue : eC2InboundPermissionsList) {
                    if (eC2InboundPermissionsListValue == null) continue;
                    IpPermissionJsonMarshaller.getInstance().marshall(eC2InboundPermissionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createFleetRequest.getNewGameSessionProtectionPolicy() != null) {
                jsonGenerator.writeFieldName("NewGameSessionProtectionPolicy").writeValue(createFleetRequest.getNewGameSessionProtectionPolicy());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

