/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.ReflectionUtils;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAnnotationMaps;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

@SdkInternalApi
final class StandardBeanProperties {
    StandardBeanProperties() {
    }

    static final <T, V> Map<String, Bean<T, V>> of(Class<T> clazz) {
        LinkedHashMap<String, Bean<T, V>> map = new LinkedHashMap<String, Bean<T, V>>();
        for (Method m : ReflectionUtils.getters(clazz)) {
            StandardAnnotationMaps.AnnotationMap annotations;
            if (m.getDeclaringClass() != clazz && (annotations = StandardAnnotationMaps.of(m.getDeclaringClass())).table() == null && annotations.document() == null) continue;
            String name = ReflectionUtils.getFieldNameByGetter(m, true);
            Bean bean = new Bean(m, new MethodReflect(m));
            StandardBeanProperties.flatten(bean, bean.annotations.attributeName(name), map);
        }
        return map;
    }

    private static <T, V> void flatten(Bean<T, V> bean, String name, Map<String, Bean<T, V>> map) {
        if (((Bean)bean).annotations.ignored()) {
            return;
        }
        if (((Bean)bean).annotations.flattened() != null) {
            Map<String, String> attributes = ((Bean)bean).annotations.attributes();
            MethodReflect declaring = ((Bean)bean).reflect;
            for (Method m : ReflectionUtils.getters(((Bean)bean).reflect.valueType())) {
                name = ReflectionUtils.getFieldNameByGetter(m, true);
                if ((name = attributes.remove(name)) == null) continue;
                bean = new Bean(m, new DeclaringMethodReflect(m, declaring));
                StandardBeanProperties.flatten(bean, name, map);
            }
            if (!attributes.isEmpty()) {
                throw new DynamoDBMappingException("contains unknown flattened attribute(s): " + attributes);
            }
        } else {
            if (map.put(name, bean) != null) {
                throw new DynamoDBMappingException("must not duplicate attribute named " + name);
            }
            if (((Bean)bean).annotations.keyType() != null && bean.getGenerateStrategy() == DynamoDBAutoGenerateStrategy.ALWAYS) {
                throw new DynamoDBMappingException("must not have auto-generated key with ALWAYS strategy");
            }
        }
    }

    private static class DeclaringMethodReflect<T, V>
    extends MethodReflect<T, V> {
        private final Reflect<T, T> declaring;

        private DeclaringMethodReflect(Method getter, Reflect<T, T> declaring) {
            super(getter);
            this.declaring = declaring;
        }

        @Override
        public V get(T object) {
            T declaringObject = this.declaring.get(object);
            if (declaringObject == null) {
                return null;
            }
            return super.get(declaringObject);
        }

        @Override
        public void set(T object, V value) {
            T declaringObject = this.declaring.get(object);
            if (declaringObject == null) {
                try {
                    declaringObject = this.declaring.valueType().newInstance();
                }
                catch (Exception e) {
                    throw new DynamoDBMappingException("could not instantiate " + this.declaring.valueType(), e);
                }
                this.declaring.set(object, declaringObject);
            }
            super.set(declaringObject, value);
        }
    }

    private static class MethodReflect<T, V>
    implements Reflect<T, V> {
        private final Method getter;
        private final Method setter;

        private MethodReflect(Method getter) {
            this.setter = ReflectionUtils.getDeclaredSetterByGetter(getter);
            this.getter = getter;
        }

        @Override
        public Class<V> valueType() {
            return this.getter.getReturnType();
        }

        @Override
        public V get(T object) {
            try {
                return (V)this.getter.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("could not invoke " + this.getter + " on " + object.getClass(), e);
            }
        }

        @Override
        public void set(T object, V value) {
            try {
                this.setter.invoke(object, value);
            }
            catch (Exception e) {
                if (this.setter == null) {
                    throw new DynamoDBMappingException("no access to public/one-argument setter for " + this.getter);
                }
                throw new DynamoDBMappingException("could not invoke " + this.setter + " on " + object.getClass(), e);
            }
        }
    }

    static interface Reflect<T, V> {
        public Class<V> valueType();

        public V get(T var1);

        public void set(T var1, V var2);
    }

    static final class Bean<T, V>
    implements DynamoDBAutoGenerator<V>,
    Reflect<T, V> {
        private final DynamoDBAutoGenerator<V> generator;
        private final MethodReflect<T, V> reflect;
        private final StandardAnnotationMaps.AnnotationMap annotations;

        private Bean(Method getter, MethodReflect<T, V> reflect) {
            this.annotations = StandardAnnotationMaps.of(getter, ReflectionUtils.getDeclaredFieldByGetter(getter));
            this.generator = this.annotations.autoGenerator(reflect.valueType());
            this.reflect = reflect;
        }

        final StandardAnnotationMaps.AnnotationMap annotations() {
            return this.annotations;
        }

        final Reflect<T, V> reflect() {
            return this.reflect;
        }

        final Method getter() {
            return ((MethodReflect)this.reflect).getter;
        }

        final Method setter() {
            if (((MethodReflect)this.reflect).setter == null) {
                throw new DynamoDBMappingException("no access to public/one-argument setter for " + ((MethodReflect)this.reflect).getter);
            }
            return ((MethodReflect)this.reflect).setter;
        }

        @Override
        public Class<V> valueType() {
            return this.reflect.valueType();
        }

        @Override
        public V get(T object) {
            return this.reflect.get(object);
        }

        @Override
        public void set(T object, V value) {
            this.reflect.set(object, value);
        }

        @Override
        public final DynamoDBAutoGenerateStrategy getGenerateStrategy() {
            return this.generator == null ? null : this.generator.getGenerateStrategy();
        }

        @Override
        public final V generate(V currentValue) {
            return this.generator.generate(currentValue);
        }
    }
}

