/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.databasemigrationservice.model.ModifyEndpointRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ModifyEndpointRequestMarshaller
implements Marshaller<Request<ModifyEndpointRequest>, ModifyEndpointRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ModifyEndpointRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ModifyEndpointRequest> marshall(ModifyEndpointRequest modifyEndpointRequest) {
        if (modifyEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyEndpointRequest> request = new DefaultRequest<ModifyEndpointRequest>(modifyEndpointRequest, "AWSDatabaseMigrationService");
        request.addHeader("X-Amz-Target", "AmazonDMSv20160101.ModifyEndpoint");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (modifyEndpointRequest.getEndpointArn() != null) {
                jsonGenerator.writeFieldName("EndpointArn").writeValue(modifyEndpointRequest.getEndpointArn());
            }
            if (modifyEndpointRequest.getEndpointIdentifier() != null) {
                jsonGenerator.writeFieldName("EndpointIdentifier").writeValue(modifyEndpointRequest.getEndpointIdentifier());
            }
            if (modifyEndpointRequest.getEndpointType() != null) {
                jsonGenerator.writeFieldName("EndpointType").writeValue(modifyEndpointRequest.getEndpointType());
            }
            if (modifyEndpointRequest.getEngineName() != null) {
                jsonGenerator.writeFieldName("EngineName").writeValue(modifyEndpointRequest.getEngineName());
            }
            if (modifyEndpointRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(modifyEndpointRequest.getUsername());
            }
            if (modifyEndpointRequest.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(modifyEndpointRequest.getPassword());
            }
            if (modifyEndpointRequest.getServerName() != null) {
                jsonGenerator.writeFieldName("ServerName").writeValue(modifyEndpointRequest.getServerName());
            }
            if (modifyEndpointRequest.getPort() != null) {
                jsonGenerator.writeFieldName("Port").writeValue(modifyEndpointRequest.getPort());
            }
            if (modifyEndpointRequest.getDatabaseName() != null) {
                jsonGenerator.writeFieldName("DatabaseName").writeValue(modifyEndpointRequest.getDatabaseName());
            }
            if (modifyEndpointRequest.getExtraConnectionAttributes() != null) {
                jsonGenerator.writeFieldName("ExtraConnectionAttributes").writeValue(modifyEndpointRequest.getExtraConnectionAttributes());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

