/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.ActionConfigurationProperty;
import com.amazonaws.services.codepipeline.model.CreateCustomActionTypeRequest;
import com.amazonaws.services.codepipeline.model.transform.ActionConfigurationPropertyJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ActionTypeSettingsJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ArtifactDetailsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateCustomActionTypeRequestMarshaller
implements Marshaller<Request<CreateCustomActionTypeRequest>, CreateCustomActionTypeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateCustomActionTypeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateCustomActionTypeRequest> marshall(CreateCustomActionTypeRequest createCustomActionTypeRequest) {
        if (createCustomActionTypeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateCustomActionTypeRequest> request = new DefaultRequest<CreateCustomActionTypeRequest>(createCustomActionTypeRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.CreateCustomActionType");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<ActionConfigurationProperty> configurationPropertiesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createCustomActionTypeRequest.getCategory() != null) {
                jsonGenerator.writeFieldName("category").writeValue(createCustomActionTypeRequest.getCategory());
            }
            if (createCustomActionTypeRequest.getProvider() != null) {
                jsonGenerator.writeFieldName("provider").writeValue(createCustomActionTypeRequest.getProvider());
            }
            if (createCustomActionTypeRequest.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(createCustomActionTypeRequest.getVersion());
            }
            if (createCustomActionTypeRequest.getSettings() != null) {
                jsonGenerator.writeFieldName("settings");
                ActionTypeSettingsJsonMarshaller.getInstance().marshall(createCustomActionTypeRequest.getSettings(), jsonGenerator);
            }
            if ((configurationPropertiesList = createCustomActionTypeRequest.getConfigurationProperties()) != null) {
                jsonGenerator.writeFieldName("configurationProperties");
                jsonGenerator.writeStartArray();
                for (ActionConfigurationProperty configurationPropertiesListValue : configurationPropertiesList) {
                    if (configurationPropertiesListValue == null) continue;
                    ActionConfigurationPropertyJsonMarshaller.getInstance().marshall(configurationPropertiesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createCustomActionTypeRequest.getInputArtifactDetails() != null) {
                jsonGenerator.writeFieldName("inputArtifactDetails");
                ArtifactDetailsJsonMarshaller.getInstance().marshall(createCustomActionTypeRequest.getInputArtifactDetails(), jsonGenerator);
            }
            if (createCustomActionTypeRequest.getOutputArtifactDetails() != null) {
                jsonGenerator.writeFieldName("outputArtifactDetails");
                ArtifactDetailsJsonMarshaller.getInstance().marshall(createCustomActionTypeRequest.getOutputArtifactDetails(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

