/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.ActionExecution;
import com.amazonaws.services.codepipeline.model.transform.ErrorDetailsJsonMarshaller;

public class ActionExecutionJsonMarshaller {
    private static ActionExecutionJsonMarshaller instance;

    public void marshall(ActionExecution actionExecution, StructuredJsonGenerator jsonGenerator) {
        if (actionExecution == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (actionExecution.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(actionExecution.getStatus());
            }
            if (actionExecution.getSummary() != null) {
                jsonGenerator.writeFieldName("summary").writeValue(actionExecution.getSummary());
            }
            if (actionExecution.getLastStatusChange() != null) {
                jsonGenerator.writeFieldName("lastStatusChange").writeValue(actionExecution.getLastStatusChange());
            }
            if (actionExecution.getExternalExecutionId() != null) {
                jsonGenerator.writeFieldName("externalExecutionId").writeValue(actionExecution.getExternalExecutionId());
            }
            if (actionExecution.getExternalExecutionUrl() != null) {
                jsonGenerator.writeFieldName("externalExecutionUrl").writeValue(actionExecution.getExternalExecutionUrl());
            }
            if (actionExecution.getPercentComplete() != null) {
                jsonGenerator.writeFieldName("percentComplete").writeValue(actionExecution.getPercentComplete());
            }
            if (actionExecution.getErrorDetails() != null) {
                jsonGenerator.writeFieldName("errorDetails");
                ErrorDetailsJsonMarshaller.getInstance().marshall(actionExecution.getErrorDetails(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActionExecutionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActionExecutionJsonMarshaller();
        }
        return instance;
    }
}

