/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.Signer;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.timers.client.ClientExecutionAbortTrackerTask;
import com.amazonaws.retry.internal.AuthErrorRetryStrategy;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.AWSRequestMetricsFullSupport;
import java.net.URI;
import java.util.List;
import org.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public class ExecutionContext {
    private final AWSRequestMetrics awsRequestMetrics;
    private final List<RequestHandler2> requestHandler2s;
    private final AmazonWebServiceClient awsClient;
    private boolean retryCapacityConsumed;
    private AWSCredentialsProvider credentialsProvider;
    private AuthErrorRetryStrategy authErrorRetryStrategy;
    private ClientExecutionAbortTrackerTask clientExecutionTrackerTask;

    public ExecutionContext(boolean isMetricEnabled) {
        this(null, isMetricEnabled, null);
    }

    public ExecutionContext() {
        this(null, false, null);
    }

    public ExecutionContext(List<RequestHandler2> requestHandler2s, boolean isMetricEnabled, AmazonWebServiceClient awsClient) {
        this.requestHandler2s = requestHandler2s;
        this.awsRequestMetrics = isMetricEnabled ? new AWSRequestMetricsFullSupport() : new AWSRequestMetrics();
        this.awsClient = awsClient;
    }

    public List<RequestHandler2> getRequestHandler2s() {
        return this.requestHandler2s;
    }

    public AWSRequestMetrics getAwsRequestMetrics() {
        return this.awsRequestMetrics;
    }

    protected AmazonWebServiceClient getAwsClient() {
        return this.awsClient;
    }

    public void setSigner(Signer signer) {
    }

    public boolean retryCapacityConsumed() {
        return this.retryCapacityConsumed;
    }

    public void markRetryCapacityConsumed() {
        this.retryCapacityConsumed = true;
    }

    public Signer getSignerByURI(URI uri) {
        return this.awsClient == null ? null : this.awsClient.getSignerByURI(uri);
    }

    public void setCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public AuthErrorRetryStrategy getAuthErrorRetryStrategy() {
        return this.authErrorRetryStrategy;
    }

    public void setAuthErrorRetryStrategy(AuthErrorRetryStrategy authErrorRetryStrategy) {
        this.authErrorRetryStrategy = authErrorRetryStrategy;
    }

    public ClientExecutionAbortTrackerTask getClientExecutionTrackerTask() {
        return this.clientExecutionTrackerTask;
    }

    public void setClientExecutionTrackerTask(ClientExecutionAbortTrackerTask clientExecutionTrackerTask) {
        this.clientExecutionTrackerTask = clientExecutionTrackerTask;
    }
}

