/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DeleteKeyPairRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteKeyPairRequestMarshaller
implements Marshaller<Request<DeleteKeyPairRequest>, DeleteKeyPairRequest> {
    @Override
    public Request<DeleteKeyPairRequest> marshall(DeleteKeyPairRequest deleteKeyPairRequest) {
        if (deleteKeyPairRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteKeyPairRequest> request = new DefaultRequest<DeleteKeyPairRequest>(deleteKeyPairRequest, "AmazonEC2");
        request.addParameter("Action", "DeleteKeyPair");
        request.addParameter("Version", "2015-04-15");
        if (deleteKeyPairRequest.getKeyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString(deleteKeyPairRequest.getKeyName()));
        }
        return request;
    }
}

