/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.Field;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import com.amazonaws.services.datapipeline.model.transform.FieldJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class PipelineObjectJsonMarshaller {
    private static PipelineObjectJsonMarshaller instance;

    public void marshall(PipelineObject pipelineObject, StructuredJsonGenerator jsonGenerator) {
        if (pipelineObject == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList fieldsList;
            jsonGenerator.writeStartObject();
            if (pipelineObject.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(pipelineObject.getId());
            }
            if (pipelineObject.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(pipelineObject.getName());
            }
            if (!(fieldsList = (SdkInternalList)pipelineObject.getFields()).isEmpty() || !fieldsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("fields");
                jsonGenerator.writeStartArray();
                for (Field fieldsListValue : fieldsList) {
                    if (fieldsListValue == null) continue;
                    FieldJsonMarshaller.getInstance().marshall(fieldsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PipelineObjectJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PipelineObjectJsonMarshaller();
        }
        return instance;
    }
}

