/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.databasemigrationservice.model.Endpoint;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class EndpointJsonMarshaller {
    private static EndpointJsonMarshaller instance;

    public void marshall(Endpoint endpoint, StructuredJsonGenerator jsonGenerator) {
        if (endpoint == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (endpoint.getEndpointIdentifier() != null) {
                jsonGenerator.writeFieldName("EndpointIdentifier").writeValue(endpoint.getEndpointIdentifier());
            }
            if (endpoint.getEndpointType() != null) {
                jsonGenerator.writeFieldName("EndpointType").writeValue(endpoint.getEndpointType());
            }
            if (endpoint.getEngineName() != null) {
                jsonGenerator.writeFieldName("EngineName").writeValue(endpoint.getEngineName());
            }
            if (endpoint.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(endpoint.getUsername());
            }
            if (endpoint.getServerName() != null) {
                jsonGenerator.writeFieldName("ServerName").writeValue(endpoint.getServerName());
            }
            if (endpoint.getPort() != null) {
                jsonGenerator.writeFieldName("Port").writeValue(endpoint.getPort());
            }
            if (endpoint.getDatabaseName() != null) {
                jsonGenerator.writeFieldName("DatabaseName").writeValue(endpoint.getDatabaseName());
            }
            if (endpoint.getExtraConnectionAttributes() != null) {
                jsonGenerator.writeFieldName("ExtraConnectionAttributes").writeValue(endpoint.getExtraConnectionAttributes());
            }
            if (endpoint.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(endpoint.getStatus());
            }
            if (endpoint.getKmsKeyId() != null) {
                jsonGenerator.writeFieldName("KmsKeyId").writeValue(endpoint.getKmsKeyId());
            }
            if (endpoint.getEndpointArn() != null) {
                jsonGenerator.writeFieldName("EndpointArn").writeValue(endpoint.getEndpointArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EndpointJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointJsonMarshaller();
        }
        return instance;
    }
}

