/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.CommandFilter;
import com.amazonaws.services.simplesystemsmanagement.model.ListCommandInvocationsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CommandFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ListCommandInvocationsRequestMarshaller
implements Marshaller<Request<ListCommandInvocationsRequest>, ListCommandInvocationsRequest> {
    @Override
    public Request<ListCommandInvocationsRequest> marshall(ListCommandInvocationsRequest listCommandInvocationsRequest) {
        if (listCommandInvocationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListCommandInvocationsRequest> request = new DefaultRequest<ListCommandInvocationsRequest>(listCommandInvocationsRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.ListCommandInvocations");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList filtersList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (listCommandInvocationsRequest.getCommandId() != null) {
                jsonGenerator.writeFieldName("CommandId").writeValue(listCommandInvocationsRequest.getCommandId());
            }
            if (listCommandInvocationsRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(listCommandInvocationsRequest.getInstanceId());
            }
            if (listCommandInvocationsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listCommandInvocationsRequest.getMaxResults());
            }
            if (listCommandInvocationsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listCommandInvocationsRequest.getNextToken());
            }
            if (!(filtersList = (SdkInternalList)listCommandInvocationsRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Filters");
                jsonGenerator.writeStartArray();
                for (CommandFilter filtersListValue : filtersList) {
                    if (filtersListValue == null) continue;
                    CommandFilterJsonMarshaller.getInstance().marshall(filtersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (listCommandInvocationsRequest.getDetails() != null) {
                jsonGenerator.writeFieldName("Details").writeValue(listCommandInvocationsRequest.getDetails());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

