/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesisfirehose.model.UpdateDestinationRequest;
import com.amazonaws.services.kinesisfirehose.model.transform.ElasticsearchDestinationUpdateJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.RedshiftDestinationUpdateJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class UpdateDestinationRequestMarshaller
implements Marshaller<Request<UpdateDestinationRequest>, UpdateDestinationRequest> {
    @Override
    public Request<UpdateDestinationRequest> marshall(UpdateDestinationRequest updateDestinationRequest) {
        if (updateDestinationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateDestinationRequest> request = new DefaultRequest<UpdateDestinationRequest>(updateDestinationRequest, "AmazonKinesisFirehose");
        request.addHeader("X-Amz-Target", "Firehose_20150804.UpdateDestination");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (updateDestinationRequest.getDeliveryStreamName() != null) {
                jsonGenerator.writeFieldName("DeliveryStreamName").writeValue(updateDestinationRequest.getDeliveryStreamName());
            }
            if (updateDestinationRequest.getCurrentDeliveryStreamVersionId() != null) {
                jsonGenerator.writeFieldName("CurrentDeliveryStreamVersionId").writeValue(updateDestinationRequest.getCurrentDeliveryStreamVersionId());
            }
            if (updateDestinationRequest.getDestinationId() != null) {
                jsonGenerator.writeFieldName("DestinationId").writeValue(updateDestinationRequest.getDestinationId());
            }
            if (updateDestinationRequest.getS3DestinationUpdate() != null) {
                jsonGenerator.writeFieldName("S3DestinationUpdate");
                S3DestinationUpdateJsonMarshaller.getInstance().marshall(updateDestinationRequest.getS3DestinationUpdate(), jsonGenerator);
            }
            if (updateDestinationRequest.getRedshiftDestinationUpdate() != null) {
                jsonGenerator.writeFieldName("RedshiftDestinationUpdate");
                RedshiftDestinationUpdateJsonMarshaller.getInstance().marshall(updateDestinationRequest.getRedshiftDestinationUpdate(), jsonGenerator);
            }
            if (updateDestinationRequest.getElasticsearchDestinationUpdate() != null) {
                jsonGenerator.writeFieldName("ElasticsearchDestinationUpdate");
                ElasticsearchDestinationUpdateJsonMarshaller.getInstance().marshall(updateDestinationRequest.getElasticsearchDestinationUpdate(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

