/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.DetachPrincipalPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DetachPrincipalPolicyRequestMarshaller
implements Marshaller<Request<DetachPrincipalPolicyRequest>, DetachPrincipalPolicyRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DetachPrincipalPolicyRequest> marshall(DetachPrincipalPolicyRequest detachPrincipalPolicyRequest) {
        if (detachPrincipalPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DetachPrincipalPolicyRequest> request = new DefaultRequest<DetachPrincipalPolicyRequest>(detachPrincipalPolicyRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (detachPrincipalPolicyRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-iot-principal", StringUtils.fromString(detachPrincipalPolicyRequest.getPrincipal()));
        }
        String uriResourcePath = "/principal-policies/{policyName}";
        uriResourcePath = uriResourcePath.replace("{policyName}", detachPrincipalPolicyRequest.getPolicyName() != null ? StringUtils.fromString(detachPrincipalPolicyRequest.getPolicyName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

