/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecr.model.SetRepositoryPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class SetRepositoryPolicyRequestMarshaller
implements Marshaller<Request<SetRepositoryPolicyRequest>, SetRepositoryPolicyRequest> {
    @Override
    public Request<SetRepositoryPolicyRequest> marshall(SetRepositoryPolicyRequest setRepositoryPolicyRequest) {
        if (setRepositoryPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetRepositoryPolicyRequest> request = new DefaultRequest<SetRepositoryPolicyRequest>(setRepositoryPolicyRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.SetRepositoryPolicy");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (setRepositoryPolicyRequest.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(setRepositoryPolicyRequest.getRegistryId());
            }
            if (setRepositoryPolicyRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(setRepositoryPolicyRequest.getRepositoryName());
            }
            if (setRepositoryPolicyRequest.getPolicyText() != null) {
                jsonGenerator.writeFieldName("policyText").writeValue(setRepositoryPolicyRequest.getPolicyText());
            }
            if (setRepositoryPolicyRequest.getForce() != null) {
                jsonGenerator.writeFieldName("force").writeValue(setRepositoryPolicyRequest.getForce());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

