/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribePlacementGroupsRequestMarshaller
implements Marshaller<Request<DescribePlacementGroupsRequest>, DescribePlacementGroupsRequest> {
    @Override
    public Request<DescribePlacementGroupsRequest> marshall(DescribePlacementGroupsRequest describePlacementGroupsRequest) {
        SdkInternalList filtersList;
        if (describePlacementGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribePlacementGroupsRequest> request = new DefaultRequest<DescribePlacementGroupsRequest>(describePlacementGroupsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribePlacementGroups");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList groupNamesList = (SdkInternalList)describePlacementGroupsRequest.getGroupNames();
        if (!groupNamesList.isEmpty() || !groupNamesList.isAutoConstruct()) {
            int groupNamesListIndex = 1;
            for (String groupNamesListValue : groupNamesList) {
                if (groupNamesListValue != null) {
                    request.addParameter("GroupName." + groupNamesListIndex, StringUtils.fromString(groupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        if (!(filtersList = (SdkInternalList)describePlacementGroupsRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

