/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.devicefarm.model.RenewOfferingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class RenewOfferingRequestMarshaller
implements Marshaller<Request<RenewOfferingRequest>, RenewOfferingRequest> {
    @Override
    public Request<RenewOfferingRequest> marshall(RenewOfferingRequest renewOfferingRequest) {
        if (renewOfferingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RenewOfferingRequest> request = new DefaultRequest<RenewOfferingRequest>(renewOfferingRequest, "AWSDeviceFarm");
        request.addHeader("X-Amz-Target", "DeviceFarm_20150623.RenewOffering");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (renewOfferingRequest.getOfferingId() != null) {
                jsonGenerator.writeFieldName("offeringId").writeValue(renewOfferingRequest.getOfferingId());
            }
            if (renewOfferingRequest.getQuantity() != null) {
                jsonGenerator.writeFieldName("quantity").writeValue(renewOfferingRequest.getQuantity());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

