/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.devicefarm.model.CreateUploadRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class CreateUploadRequestMarshaller
implements Marshaller<Request<CreateUploadRequest>, CreateUploadRequest> {
    @Override
    public Request<CreateUploadRequest> marshall(CreateUploadRequest createUploadRequest) {
        if (createUploadRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateUploadRequest> request = new DefaultRequest<CreateUploadRequest>(createUploadRequest, "AWSDeviceFarm");
        request.addHeader("X-Amz-Target", "DeviceFarm_20150623.CreateUpload");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (createUploadRequest.getProjectArn() != null) {
                jsonGenerator.writeFieldName("projectArn").writeValue(createUploadRequest.getProjectArn());
            }
            if (createUploadRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(createUploadRequest.getName());
            }
            if (createUploadRequest.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(createUploadRequest.getType());
            }
            if (createUploadRequest.getContentType() != null) {
                jsonGenerator.writeFieldName("contentType").writeValue(createUploadRequest.getContentType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

