/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codepipeline.model.JobDetails;
import com.amazonaws.services.codepipeline.model.transform.JobDataJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class JobDetailsJsonMarshaller {
    private static JobDetailsJsonMarshaller instance;

    public void marshall(JobDetails jobDetails, StructuredJsonGenerator jsonGenerator) {
        if (jobDetails == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (jobDetails.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(jobDetails.getId());
            }
            if (jobDetails.getData() != null) {
                jsonGenerator.writeFieldName("data");
                JobDataJsonMarshaller.getInstance().marshall(jobDetails.getData(), jsonGenerator);
            }
            if (jobDetails.getAccountId() != null) {
                jsonGenerator.writeFieldName("accountId").writeValue(jobDetails.getAccountId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobDetailsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobDetailsJsonMarshaller();
        }
        return instance;
    }
}

