/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetSdkRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class GetSdkRequestMarshaller
implements Marshaller<Request<GetSdkRequest>, GetSdkRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetSdkRequest> marshall(GetSdkRequest getSdkRequest) {
        if (getSdkRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetSdkRequest> request = new DefaultRequest<GetSdkRequest>(getSdkRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/stages/{stage_name}/sdks/{sdk_type}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getSdkRequest.getRestApiId() != null ? StringUtils.fromString(getSdkRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{stage_name}", getSdkRequest.getStageName() != null ? StringUtils.fromString(getSdkRequest.getStageName()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{sdk_type}", getSdkRequest.getSdkType() != null ? StringUtils.fromString(getSdkRequest.getSdkType()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        Map<String, String> parameters = getSdkRequest.getParameters();
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (entry.getValue() == null) continue;
                request.addParameter(StringUtils.fromString(entry.getKey()), StringUtils.fromString(entry.getValue()));
            }
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

