/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetDeploymentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetDeploymentRequestMarshaller
implements Marshaller<Request<GetDeploymentRequest>, GetDeploymentRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetDeploymentRequest> marshall(GetDeploymentRequest getDeploymentRequest) {
        if (getDeploymentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDeploymentRequest> request = new DefaultRequest<GetDeploymentRequest>(getDeploymentRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/deployments/{deployment_id}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getDeploymentRequest.getRestApiId() != null ? StringUtils.fromString(getDeploymentRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{deployment_id}", getDeploymentRequest.getDeploymentId() != null ? StringUtils.fromString(getDeploymentRequest.getDeploymentId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

