/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.storagegateway.model.AddCacheRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class AddCacheRequestMarshaller
implements Marshaller<Request<AddCacheRequest>, AddCacheRequest> {
    @Override
    public Request<AddCacheRequest> marshall(AddCacheRequest addCacheRequest) {
        if (addCacheRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddCacheRequest> request = new DefaultRequest<AddCacheRequest>(addCacheRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.AddCache");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList diskIdsList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (addCacheRequest.getGatewayARN() != null) {
                jsonGenerator.writeFieldName("GatewayARN").writeValue(addCacheRequest.getGatewayARN());
            }
            if (!(diskIdsList = (SdkInternalList)addCacheRequest.getDiskIds()).isEmpty() || !diskIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DiskIds");
                jsonGenerator.writeStartArray();
                for (String diskIdsListValue : diskIdsList) {
                    if (diskIdsListValue == null) continue;
                    jsonGenerator.writeValue(diskIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

