/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.VpcConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UpdateFunctionConfigurationRequestMarshaller
implements Marshaller<Request<UpdateFunctionConfigurationRequest>, UpdateFunctionConfigurationRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<UpdateFunctionConfigurationRequest> marshall(UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) {
        if (updateFunctionConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateFunctionConfigurationRequest> request = new DefaultRequest<UpdateFunctionConfigurationRequest>(updateFunctionConfigurationRequest, "AWSLambda");
        String target = "AWSLambda.UpdateFunctionConfiguration";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("FunctionName")) {
            String value;
            String name = DYNAMIC_QUERY_PARAMS.get("FunctionName");
            String string = value = updateFunctionConfigurationRequest.getFunctionName() == null ? null : StringUtils.fromString(updateFunctionConfigurationRequest.getFunctionName());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{FunctionName}", updateFunctionConfigurationRequest.getFunctionName() == null ? "" : StringUtils.fromString(updateFunctionConfigurationRequest.getFunctionName()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        try {
            VpcConfig vpcConfig;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateFunctionConfigurationRequest.getRole() != null) {
                jsonWriter.key("Role").value(updateFunctionConfigurationRequest.getRole());
            }
            if (updateFunctionConfigurationRequest.getHandler() != null) {
                jsonWriter.key("Handler").value(updateFunctionConfigurationRequest.getHandler());
            }
            if (updateFunctionConfigurationRequest.getDescription() != null) {
                jsonWriter.key("Description").value(updateFunctionConfigurationRequest.getDescription());
            }
            if (updateFunctionConfigurationRequest.getTimeout() != null) {
                jsonWriter.key("Timeout").value(updateFunctionConfigurationRequest.getTimeout());
            }
            if (updateFunctionConfigurationRequest.getMemorySize() != null) {
                jsonWriter.key("MemorySize").value(updateFunctionConfigurationRequest.getMemorySize());
            }
            if ((vpcConfig = updateFunctionConfigurationRequest.getVpcConfig()) != null) {
                ListWithAutoConstructFlag securityGroupIdsList;
                jsonWriter.key("VpcConfig");
                jsonWriter.object();
                ListWithAutoConstructFlag subnetIdsList = (ListWithAutoConstructFlag)vpcConfig.getSubnetIds();
                if (!(subnetIdsList == null || subnetIdsList.isAutoConstruct() && subnetIdsList.isEmpty())) {
                    jsonWriter.key("SubnetIds");
                    jsonWriter.array();
                    for (String subnetIdsListValue : subnetIdsList) {
                        if (subnetIdsListValue == null) continue;
                        jsonWriter.value(subnetIdsListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((securityGroupIdsList = (ListWithAutoConstructFlag)vpcConfig.getSecurityGroupIds()) == null || securityGroupIdsList.isAutoConstruct() && securityGroupIdsList.isEmpty())) {
                    jsonWriter.key("SecurityGroupIds");
                    jsonWriter.array();
                    for (String securityGroupIdsListValue : securityGroupIdsList) {
                        if (securityGroupIdsListValue == null) continue;
                        jsonWriter.value(securityGroupIdsListValue);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if (updateFunctionConfigurationRequest.getRuntime() != null) {
                jsonWriter.key("Runtime").value(updateFunctionConfigurationRequest.getRuntime());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    static {
        String path = "/2015-03-31/functions/{FunctionName}/configuration";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

