/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.RedshiftDestinationDescription;
import com.amazonaws.services.kinesisfirehose.model.transform.CloudWatchLoggingOptionsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.CopyCommandJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationDescriptionJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class RedshiftDestinationDescriptionJsonMarshaller {
    private static RedshiftDestinationDescriptionJsonMarshaller instance;

    public void marshall(RedshiftDestinationDescription redshiftDestinationDescription, StructuredJsonGenerator jsonGenerator) {
        if (redshiftDestinationDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (redshiftDestinationDescription.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(redshiftDestinationDescription.getRoleARN());
            }
            if (redshiftDestinationDescription.getClusterJDBCURL() != null) {
                jsonGenerator.writeFieldName("ClusterJDBCURL").writeValue(redshiftDestinationDescription.getClusterJDBCURL());
            }
            if (redshiftDestinationDescription.getCopyCommand() != null) {
                jsonGenerator.writeFieldName("CopyCommand");
                CopyCommandJsonMarshaller.getInstance().marshall(redshiftDestinationDescription.getCopyCommand(), jsonGenerator);
            }
            if (redshiftDestinationDescription.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(redshiftDestinationDescription.getUsername());
            }
            if (redshiftDestinationDescription.getS3DestinationDescription() != null) {
                jsonGenerator.writeFieldName("S3DestinationDescription");
                S3DestinationDescriptionJsonMarshaller.getInstance().marshall(redshiftDestinationDescription.getS3DestinationDescription(), jsonGenerator);
            }
            if (redshiftDestinationDescription.getCloudWatchLoggingOptions() != null) {
                jsonGenerator.writeFieldName("CloudWatchLoggingOptions");
                CloudWatchLoggingOptionsJsonMarshaller.getInstance().marshall(redshiftDestinationDescription.getCloudWatchLoggingOptions(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RedshiftDestinationDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RedshiftDestinationDescriptionJsonMarshaller();
        }
        return instance;
    }
}

