/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.RejectCertificateTransferRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;

public class RejectCertificateTransferRequestMarshaller
implements Marshaller<Request<RejectCertificateTransferRequest>, RejectCertificateTransferRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<RejectCertificateTransferRequest> marshall(RejectCertificateTransferRequest rejectCertificateTransferRequest) {
        if (rejectCertificateTransferRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RejectCertificateTransferRequest> request = new DefaultRequest<RejectCertificateTransferRequest>(rejectCertificateTransferRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/reject-certificate-transfer/{certificateId}";
        uriResourcePath = uriResourcePath.replace("{certificateId}", rejectCertificateTransferRequest.getCertificateId() != null ? StringUtils.fromString(rejectCertificateTransferRequest.getCertificateId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (rejectCertificateTransferRequest.getRejectReason() != null) {
                jsonGenerator.writeFieldName("rejectReason").writeValue(rejectCertificateTransferRequest.getRejectReason());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

