/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.ListBuildsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ListBuildsRequestMarshaller
implements Marshaller<Request<ListBuildsRequest>, ListBuildsRequest> {
    @Override
    public Request<ListBuildsRequest> marshall(ListBuildsRequest listBuildsRequest) {
        if (listBuildsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListBuildsRequest> request = new DefaultRequest<ListBuildsRequest>(listBuildsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.ListBuilds");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (listBuildsRequest.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(listBuildsRequest.getStatus());
            }
            if (listBuildsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listBuildsRequest.getLimit());
            }
            if (listBuildsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listBuildsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

