/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.DeleteBuildRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class DeleteBuildRequestMarshaller
implements Marshaller<Request<DeleteBuildRequest>, DeleteBuildRequest> {
    @Override
    public Request<DeleteBuildRequest> marshall(DeleteBuildRequest deleteBuildRequest) {
        if (deleteBuildRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteBuildRequest> request = new DefaultRequest<DeleteBuildRequest>(deleteBuildRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.DeleteBuild");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (deleteBuildRequest.getBuildId() != null) {
                jsonGenerator.writeFieldName("BuildId").writeValue(deleteBuildRequest.getBuildId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

