/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecr.model.Layer;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class LayerJsonMarshaller {
    private static LayerJsonMarshaller instance;

    public void marshall(Layer layer, StructuredJsonGenerator jsonGenerator) {
        if (layer == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (layer.getLayerDigest() != null) {
                jsonGenerator.writeFieldName("layerDigest").writeValue(layer.getLayerDigest());
            }
            if (layer.getLayerAvailability() != null) {
                jsonGenerator.writeFieldName("layerAvailability").writeValue(layer.getLayerAvailability());
            }
            if (layer.getLayerSize() != null) {
                jsonGenerator.writeFieldName("layerSize").writeValue(layer.getLayerSize());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LayerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LayerJsonMarshaller();
        }
        return instance;
    }
}

