/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecr.model.GetDownloadUrlForLayerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class GetDownloadUrlForLayerRequestMarshaller
implements Marshaller<Request<GetDownloadUrlForLayerRequest>, GetDownloadUrlForLayerRequest> {
    @Override
    public Request<GetDownloadUrlForLayerRequest> marshall(GetDownloadUrlForLayerRequest getDownloadUrlForLayerRequest) {
        if (getDownloadUrlForLayerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDownloadUrlForLayerRequest> request = new DefaultRequest<GetDownloadUrlForLayerRequest>(getDownloadUrlForLayerRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.GetDownloadUrlForLayer");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (getDownloadUrlForLayerRequest.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(getDownloadUrlForLayerRequest.getRegistryId());
            }
            if (getDownloadUrlForLayerRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(getDownloadUrlForLayerRequest.getRepositoryName());
            }
            if (getDownloadUrlForLayerRequest.getLayerDigest() != null) {
                jsonGenerator.writeFieldName("layerDigest").writeValue(getDownloadUrlForLayerRequest.getLayerDigest());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

