/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directory.model.EnableSsoRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class EnableSsoRequestMarshaller
implements Marshaller<Request<EnableSsoRequest>, EnableSsoRequest> {
    @Override
    public Request<EnableSsoRequest> marshall(EnableSsoRequest enableSsoRequest) {
        if (enableSsoRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EnableSsoRequest> request = new DefaultRequest<EnableSsoRequest>(enableSsoRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.EnableSso");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (enableSsoRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(enableSsoRequest.getDirectoryId());
            }
            if (enableSsoRequest.getUserName() != null) {
                jsonGenerator.writeFieldName("UserName").writeValue(enableSsoRequest.getUserName());
            }
            if (enableSsoRequest.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(enableSsoRequest.getPassword());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

