/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.DescribeDirectoriesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class DescribeDirectoriesRequestMarshaller
implements Marshaller<Request<DescribeDirectoriesRequest>, DescribeDirectoriesRequest> {
    @Override
    public Request<DescribeDirectoriesRequest> marshall(DescribeDirectoriesRequest describeDirectoriesRequest) {
        if (describeDirectoriesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeDirectoriesRequest> request = new DefaultRequest<DescribeDirectoriesRequest>(describeDirectoriesRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.DescribeDirectories");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            SdkInternalList directoryIdsList = (SdkInternalList)describeDirectoriesRequest.getDirectoryIds();
            if (!directoryIdsList.isEmpty() || !directoryIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DirectoryIds");
                jsonGenerator.writeStartArray();
                for (String directoryIdsListValue : directoryIdsList) {
                    if (directoryIdsListValue == null) continue;
                    jsonGenerator.writeValue(directoryIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeDirectoriesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeDirectoriesRequest.getNextToken());
            }
            if (describeDirectoriesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeDirectoriesRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

