/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidp.model.DeleteUserAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DeleteUserAttributesRequestMarshaller
implements Marshaller<Request<DeleteUserAttributesRequest>, DeleteUserAttributesRequest> {
    @Override
    public Request<DeleteUserAttributesRequest> marshall(DeleteUserAttributesRequest deleteUserAttributesRequest) {
        if (deleteUserAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteUserAttributesRequest> request = new DefaultRequest<DeleteUserAttributesRequest>(deleteUserAttributesRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.DeleteUserAttributes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            List<String> userAttributeNamesList = deleteUserAttributesRequest.getUserAttributeNames();
            if (userAttributeNamesList != null) {
                jsonGenerator.writeFieldName("UserAttributeNames");
                jsonGenerator.writeStartArray();
                for (String userAttributeNamesListValue : userAttributeNamesList) {
                    if (userAttributeNamesListValue == null) continue;
                    jsonGenerator.writeValue(userAttributeNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (deleteUserAttributesRequest.getAccessToken() != null) {
                jsonGenerator.writeFieldName("AccessToken").writeValue(deleteUserAttributesRequest.getAccessToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

