/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.DeleteIntegrationResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteIntegrationResponseRequestMarshaller
implements Marshaller<Request<DeleteIntegrationResponseRequest>, DeleteIntegrationResponseRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DeleteIntegrationResponseRequest> marshall(DeleteIntegrationResponseRequest deleteIntegrationResponseRequest) {
        if (deleteIntegrationResponseRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteIntegrationResponseRequest> request = new DefaultRequest<DeleteIntegrationResponseRequest>(deleteIntegrationResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", deleteIntegrationResponseRequest.getRestApiId() != null ? StringUtils.fromString(deleteIntegrationResponseRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{resource_id}", deleteIntegrationResponseRequest.getResourceId() != null ? StringUtils.fromString(deleteIntegrationResponseRequest.getResourceId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{http_method}", deleteIntegrationResponseRequest.getHttpMethod() != null ? StringUtils.fromString(deleteIntegrationResponseRequest.getHttpMethod()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{status_code}", deleteIntegrationResponseRequest.getStatusCode() != null ? StringUtils.fromString(deleteIntegrationResponseRequest.getStatusCode()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

