/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.waf.model.DeleteRuleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class DeleteRuleRequestMarshaller
implements Marshaller<Request<DeleteRuleRequest>, DeleteRuleRequest> {
    @Override
    public Request<DeleteRuleRequest> marshall(DeleteRuleRequest deleteRuleRequest) {
        if (deleteRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteRuleRequest> request = new DefaultRequest<DeleteRuleRequest>(deleteRuleRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.DeleteRule");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (deleteRuleRequest.getRuleId() != null) {
                jsonGenerator.writeFieldName("RuleId").writeValue(deleteRuleRequest.getRuleId());
            }
            if (deleteRuleRequest.getChangeToken() != null) {
                jsonGenerator.writeFieldName("ChangeToken").writeValue(deleteRuleRequest.getChangeToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

