/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.CreatePlayerSessionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreatePlayerSessionsRequestMarshaller
implements Marshaller<Request<CreatePlayerSessionsRequest>, CreatePlayerSessionsRequest> {
    @Override
    public Request<CreatePlayerSessionsRequest> marshall(CreatePlayerSessionsRequest createPlayerSessionsRequest) {
        if (createPlayerSessionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePlayerSessionsRequest> request = new DefaultRequest<CreatePlayerSessionsRequest>(createPlayerSessionsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.CreatePlayerSessions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> playerIdsList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (createPlayerSessionsRequest.getGameSessionId() != null) {
                jsonGenerator.writeFieldName("GameSessionId").writeValue(createPlayerSessionsRequest.getGameSessionId());
            }
            if ((playerIdsList = createPlayerSessionsRequest.getPlayerIds()) != null) {
                jsonGenerator.writeFieldName("PlayerIds");
                jsonGenerator.writeStartArray();
                for (String playerIdsListValue : playerIdsList) {
                    if (playerIdsListValue == null) continue;
                    jsonGenerator.writeValue(playerIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

