/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ListBootstrapActionsRequestMarshaller
implements Marshaller<Request<ListBootstrapActionsRequest>, ListBootstrapActionsRequest> {
    @Override
    public Request<ListBootstrapActionsRequest> marshall(ListBootstrapActionsRequest listBootstrapActionsRequest) {
        if (listBootstrapActionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListBootstrapActionsRequest> request = new DefaultRequest<ListBootstrapActionsRequest>(listBootstrapActionsRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.ListBootstrapActions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (listBootstrapActionsRequest.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(listBootstrapActionsRequest.getClusterId());
            }
            if (listBootstrapActionsRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listBootstrapActionsRequest.getMarker());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

