/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directory.model.UpdateRadiusRequest;
import com.amazonaws.services.directory.model.transform.RadiusSettingsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class UpdateRadiusRequestMarshaller
implements Marshaller<Request<UpdateRadiusRequest>, UpdateRadiusRequest> {
    @Override
    public Request<UpdateRadiusRequest> marshall(UpdateRadiusRequest updateRadiusRequest) {
        if (updateRadiusRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateRadiusRequest> request = new DefaultRequest<UpdateRadiusRequest>(updateRadiusRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.UpdateRadius");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (updateRadiusRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(updateRadiusRequest.getDirectoryId());
            }
            if (updateRadiusRequest.getRadiusSettings() != null) {
                jsonGenerator.writeFieldName("RadiusSettings");
                RadiusSettingsJsonMarshaller.getInstance().marshall(updateRadiusRequest.getRadiusSettings(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

