/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.directory.model.Snapshot;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class SnapshotJsonMarshaller {
    private static SnapshotJsonMarshaller instance;

    public void marshall(Snapshot snapshot, StructuredJsonGenerator jsonGenerator) {
        if (snapshot == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (snapshot.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(snapshot.getDirectoryId());
            }
            if (snapshot.getSnapshotId() != null) {
                jsonGenerator.writeFieldName("SnapshotId").writeValue(snapshot.getSnapshotId());
            }
            if (snapshot.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(snapshot.getType());
            }
            if (snapshot.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(snapshot.getName());
            }
            if (snapshot.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(snapshot.getStatus());
            }
            if (snapshot.getStartTime() != null) {
                jsonGenerator.writeFieldName("StartTime").writeValue(snapshot.getStartTime());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SnapshotJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SnapshotJsonMarshaller();
        }
        return instance;
    }
}

