/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directconnect.model.ConfirmConnectionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ConfirmConnectionRequestMarshaller
implements Marshaller<Request<ConfirmConnectionRequest>, ConfirmConnectionRequest> {
    @Override
    public Request<ConfirmConnectionRequest> marshall(ConfirmConnectionRequest confirmConnectionRequest) {
        if (confirmConnectionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ConfirmConnectionRequest> request = new DefaultRequest<ConfirmConnectionRequest>(confirmConnectionRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.ConfirmConnection");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (confirmConnectionRequest.getConnectionId() != null) {
                jsonGenerator.writeFieldName("connectionId").writeValue(confirmConnectionRequest.getConnectionId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

